<?php

/**
 * This is the model class for table "{{flujo_efectivo}}".
 *
 * The followings are the available columns in table '{{flujo_efectivo}}':
 * @property integer $id_flujo
 * @property string $fecha
 * @property string $concepto
 * @property string $importe
 * @property string $observaciones
 */
class Flujo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Flujo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{flujo_efectivo}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha, concepto, importe', 'required'),
			array('concepto', 'length', 'max'=>255),
			array('importe', 'length', 'max'=>45),
			array('fecha, observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_flujo, fecha, concepto, importe, observaciones', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_flujo' => 'Id Flujo',
			'fecha' => 'Fecha',
			'concepto' => 'Concepto',
			'importe' => 'Importe',
			'observaciones' => 'Observaciones',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_flujo',$this->id_flujo);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('concepto',$this->concepto,true);
		$criteria->compare('importe',$this->importe,true);
		$criteria->compare('observaciones',$this->observaciones,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}