<?php

/**
 * This is the model class for table "{{gastos}}".
 *
 * The followings are the available columns in table '{{gastos}}':
 * @property integer $id_gasto
 * @property integer $id_evento
 * @property string $descripcion
 * @property double $importe
 * @property string $fecha_gasto
 * @property string $log
 * @property integer $id_user
 * @property string $referencia
 * @property string $comprobante
 *
 * The followings are the available model relations:
 * @property Events $idEvento
 * @property Users $idUser
 */
class Gastos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Gastos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{gastos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_evento, descripcion, importe, fecha_gasto, id_user', 'required'),
			array('id_evento, id_user', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('descripcion, comprobante', 'length', 'max'=>100),
			array('referencia', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_gasto, id_evento, descripcion, importe, fecha_gasto, log, id_user, referencia, comprobante', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idEvento' => array(self::BELONGS_TO, 'Events', 'id_evento'),
			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_gasto' => 'Id Gasto',
			'id_evento' => 'Id Evento',
			'descripcion' => 'Descripcion',
			'importe' => 'Importe',
			'fecha_gasto' => 'Fecha Gasto',
			'log' => 'Log',
			'id_user' => 'Id User',
			'referencia' => 'Referencia',
			'comprobante' => 'Comprobante',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_gasto',$this->id_gasto);
		$criteria->compare('id_evento',$this->id_evento);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('fecha_gasto',$this->fecha_gasto,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('comprobante',$this->comprobante,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}