<?php



/**

 * This is the model class for table "{{hotel_serv_def}}".

 *

 * The followings are the available columns in table '{{hotel_serv_def}}':

 * @property integer $id_hotel_serv_def

 * @property integer $id_hotel

 * @property integer $id_serv_def

 * @property integer $estatus

 * @property string $log

 *

 * The followings are the available model relations:

 * @property ServDef $idServDef

 */

class HotelServDef extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return HotelServDef the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{hotel_serv_def}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_hotel, id_serv_def', 'required'),

			array('id_hotel, id_serv_def, estatus', 'numerical', 'integerOnly'=>true),

			array('log', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_hotel_serv_def, id_hotel, id_serv_def, estatus, log', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idServDef' => array(self::BELONGS_TO, 'ServDef', 'id_serv_def'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_hotel_serv_def' => 'Id Hotel Serv Def',

			'id_hotel' => 'Hotel',

			'id_serv_def' => 'Servicio',

			'estatus' => 'Estatus',

			'log' => 'Log',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_hotel_serv_def',$this->id_hotel_serv_def);

		$criteria->compare('id_hotel',$this->id_hotel);

		$criteria->compare('id_serv_def',$this->id_serv_def);

		$criteria->compare('estatus',$this->estatus);

		$criteria->compare('log',$this->log,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}