<?php

/**
 * This is the model class for table "{{hoteles}}".
 *
 * The followings are the available columns in table '{{hoteles}}':
 * @property string $id_hotel
 * @property integer $id_destino
 * @property string $nombre_hotel
 * @property string $tel_hotel1
 * @property string $tel_hotel2
 * @property string $tel_hotel3
 * @property string $contacto_hotel
 * @property string $email_hotel
 * @property string $estrellas
 * @property integer $max_ninios
 * @property integer $max_jrs
 * @property string $observaciones
 * @property string $id_pais_hotel
 * @property string $id_estado_hotel
 * @property string $id_ciudad_hotel
 * @property string $id_colonia_hotel
 * @property string $municipio_hotel
 * @property string $cp_hotel
 * @property string $calle_hotel
 * @property string $num_exterior_hotel
 * @property string $num_interior_hotel
 * @property string $cruzamientos_hotel
 * @property string $razon_social
 * @property string $rfc_hotel
 * @property string $id_pais_fiscal
 * @property string $id_estado_fiscal
 * @property string $id_ciudad_fiscal
 * @property string $id_colonia_fiscal
 * @property string $calle_fiscal
 * @property string $cruzamientos_fiscal
 * @property string $cp_fiscal
 * @property string $municipio_fiscal
 * @property string $num_interior_fiscal
 * @property string $num_exterior_fiscal
 * @property string $log
 * @property integer $estatus
 * @property integer $mismadir
 * @property integer $id_categoria
 *
 * The followings are the available model relations:
 * @property HotelesDestinos[] $hotelesDestinoses
 * @property HotelesFotos[] $hotelesFotoses
 * @property PreciosDestino[] $preciosDestinos
 */
class Hoteles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Hoteles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_hotel, tel_hotel1, id_pais_hotel, municipio_hotel, cp_hotel, estatus', 'required'),
			array('id_destino, max_ninios, max_jrs, estatus, mismadir, id_categoria', 'numerical', 'integerOnly'=>true),
			array('nombre_hotel, contacto_hotel, id_estado_hotel, id_ciudad_hotel, id_colonia_hotel, municipio_hotel, calle_hotel, razon_social, id_pais_fiscal, calle_fiscal', 'length', 'max'=>255),
			array('tel_hotel1, tel_hotel2, tel_hotel3, email_hotel, num_exterior_hotel, num_interior_hotel, cruzamientos_hotel, rfc_hotel, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, cruzamientos_fiscal, cp_fiscal, municipio_fiscal, num_interior_fiscal, num_exterior_fiscal', 'length', 'max'=>45),
			array('estrellas', 'length', 'max'=>5),
			array('id_pais_hotel', 'length', 'max'=>45),
			array('cp_hotel', 'length', 'max'=>15),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_hotel, id_destino, nombre_hotel, tel_hotel1, tel_hotel2, tel_hotel3, contacto_hotel, email_hotel, estrellas, max_ninios, max_jrs, observaciones, id_pais_hotel, id_estado_hotel, id_ciudad_hotel, id_colonia_hotel, municipio_hotel, cp_hotel, calle_hotel, num_exterior_hotel, num_interior_hotel, cruzamientos_hotel, razon_social, rfc_hotel, id_pais_fiscal, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, calle_fiscal, cruzamientos_fiscal, cp_fiscal, municipio_fiscal, num_interior_fiscal, num_exterior_fiscal, log, estatus, mismadir, id_categoria', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'hotelesDestinoses' => array(self::HAS_MANY, 'HotelesDestinos', 'id_hotel'),
			'hotelesFotoses' => array(self::HAS_MANY, 'HotelesFotos', 'id_hotel'),
			'preciosDestinos' => array(self::HAS_MANY, 'PreciosDestino', 'id_hotel'),
			'Destino' => array(self::BELONGS_TO, 'Destinos', 'id_destino'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_hotel' => 'Hotel',
			'id_destino' => 'Destino',
			'nombre_hotel' => 'Nombre',
			'tel_hotel1' => 'Telefono Principal',
			'tel_hotel2' => 'Telefono 2',
			'tel_hotel3' => 'Telefono 3',
			'contacto_hotel' => 'Contacto',
			'email_hotel' => 'Email',
			'estrellas' => 'Categoría',
			'max_ninios' => 'Máx. Niños',
			'max_jrs' => 'Máx. Juniors.',
			'observaciones' => 'Observaciones',
			'id_pais_hotel' => 'Pais',
			'id_estado_hotel' => 'Estado',
			'id_ciudad_hotel' => 'Ciudad',
			'id_colonia_hotel' => 'Colonia',
			'municipio_hotel' => 'Municipio',
			'cp_hotel' => 'CP',
			'calle_hotel' => 'Calle',
			'num_exterior_hotel' => 'Núm. Exterior',
			'num_interior_hotel' => 'Núm Interior',
			'cruzamientos_hotel' => 'Cruzamientos',
			'razon_social' => 'Razon Social',
			'rfc_hotel' => 'RFC',
			'id_pais_fiscal' => 'Pais',
			'id_estado_fiscal' => 'Estado',
			'id_ciudad_fiscal' => 'Ciudad',
			'id_colonia_fiscal' => 'Colonia',
			'calle_fiscal' => 'Calle',
			'cruzamientos_fiscal' => 'Cruzamientos',
			'cp_fiscal' => 'CP',
			'municipio_fiscal' => 'Municipio',
			'num_interior_fiscal' => 'Núm. Interior',
			'num_exterior_fiscal' => 'Núm. Exterior',
			'log' => 'Log',
			'estatus' => 'Estatus',
			'mismadir' => 'Mismadir',
			'id_categoria' => 'Categoria',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_destino',$this->id_destino);
		$criteria->compare('nombre_hotel',$this->nombre_hotel,true);
		$criteria->compare('tel_hotel1',$this->tel_hotel1,true);
		$criteria->compare('tel_hotel2',$this->tel_hotel2,true);
		$criteria->compare('tel_hotel3',$this->tel_hotel3,true);
		$criteria->compare('contacto_hotel',$this->contacto_hotel,true);
		$criteria->compare('email_hotel',$this->email_hotel,true);
		$criteria->compare('estrellas',$this->estrellas,true);
		$criteria->compare('max_ninios',$this->max_ninios);
		$criteria->compare('max_jrs',$this->max_jrs);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('id_pais_hotel',$this->id_pais_hotel,true);
		$criteria->compare('id_estado_hotel',$this->id_estado_hotel,true);
		$criteria->compare('id_ciudad_hotel',$this->id_ciudad_hotel,true);
		$criteria->compare('id_colonia_hotel',$this->id_colonia_hotel,true);
		$criteria->compare('municipio_hotel',$this->municipio_hotel,true);
		$criteria->compare('cp_hotel',$this->cp_hotel,true);
		$criteria->compare('calle_hotel',$this->calle_hotel,true);
		$criteria->compare('num_exterior_hotel',$this->num_exterior_hotel,true);
		$criteria->compare('num_interior_hotel',$this->num_interior_hotel,true);
		$criteria->compare('cruzamientos_hotel',$this->cruzamientos_hotel,true);
		$criteria->compare('razon_social',$this->razon_social,true);
		$criteria->compare('rfc_hotel',$this->rfc_hotel,true);
		$criteria->compare('id_pais_fiscal',$this->id_pais_fiscal,true);
		$criteria->compare('id_estado_fiscal',$this->id_estado_fiscal,true);
		$criteria->compare('id_ciudad_fiscal',$this->id_ciudad_fiscal,true);
		$criteria->compare('id_colonia_fiscal',$this->id_colonia_fiscal,true);
		$criteria->compare('calle_fiscal',$this->calle_fiscal,true);
		$criteria->compare('cruzamientos_fiscal',$this->cruzamientos_fiscal,true);
		$criteria->compare('cp_fiscal',$this->cp_fiscal,true);
		$criteria->compare('municipio_fiscal',$this->municipio_fiscal,true);
		$criteria->compare('num_interior_fiscal',$this->num_interior_fiscal,true);
		$criteria->compare('num_exterior_fiscal',$this->num_exterior_fiscal,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('mismadir',$this->mismadir);
		$criteria->compare('id_categoria',$this->id_categoria);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}