<?php

/**
 * This is the model class for table "{{hoteles_extranet}}".
 *
 * The followings are the available columns in table '{{hoteles_extranet}}':
 * @property integer $idExtranet
 * @property string $idHotel
 * @property integer $idUsuario
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel0
 * @property Users $idUsuario0
 */
class HotelesExtranet extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HotelesExtranet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles_extranet}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('idHotel, idUsuario', 'required'),
			array('idUsuario', 'numerical', 'integerOnly'=>true),
			array('idHotel', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idExtranet, idHotel, idUsuario', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel0' => array(self::BELONGS_TO, 'Hoteles', 'idHotel'),
			'idUsuario0' => array(self::BELONGS_TO, 'Users', 'idUsuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idExtranet' => 'Id Extranet',
			'idHotel' => 'Id Hotel',
			'idUsuario' => 'Id Usuario',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idExtranet',$this->idExtranet);
		$criteria->compare('idHotel',$this->idHotel,true);
		$criteria->compare('idUsuario',$this->idUsuario);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}