<?php

/**
 * This is the model class for table "{{hoteles_facilities}}".
 *
 * The followings are the available columns in table '{{hoteles_facilities}}':
 * @property integer $id_hotelFacilities
 * @property integer $id_hotel
 * @property integer $id_facilities
 *
 * The followings are the available model relations:
 * @property Facilities $idFacilities
 */
class HotelesFacilities extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HotelesFacilities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles_facilities}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, id_facilities', 'required'),
			array('id_hotel, id_facilities', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_hotelFacilities, id_hotel, id_facilities', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idServDef' => array(self::BELONGS_TO, 'Facilities', 'id_facilities'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_hotelFacilities' => 'Id Hotel Facilities',
			'id_hotel' => 'Id Hotel',
			'id_facilities' => 'Id Facilities',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_hotelFacilities',$this->id_hotelFacilities);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('id_facilities',$this->id_facilities);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}