<?php

/**
 * This is the model class for table "{{hoteles_fotos}}".
 *
 * The followings are the available columns in table '{{hoteles_fotos}}':
 * @property string $id_foto
 * @property string $id_hotel
 * @property string $piedefoto
 * @property string $foto
 * @property string $log
 * @property integer $principal
 * @property integer $logotipo
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 */
class HotelesFotos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HotelesFotos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles_fotos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, foto', 'required'),
			array('principal, logotipo, boda', 'numerical', 'integerOnly'=>true),
			array('id_hotel', 'length', 'max'=>10),
			array('piedefoto, foto', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_foto, id_hotel, piedefoto, foto, log, principal, logotipo, boda', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_foto' => 'Id Foto',
			'id_hotel' => 'Id Hotel',
			'piedefoto' => 'Piedefoto',
			'foto' => 'Foto',
			'log' => 'Log',
			'principal' => 'Principal',
			'logotipo' => 'Logotipo',
			'boda' => 'Boda',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_foto',$this->id_foto,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('piedefoto',$this->piedefoto,true);
		$criteria->compare('foto',$this->foto,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('principal',$this->principal);
		$criteria->compare('logotipo',$this->logotipo);
		$criteria->compare('boda',$this->boda);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}