<?php



/**

 * This is the model class for table "{{log_Activities}}".

 *

 * The followings are the available columns in table '{{log_Activities}}':

 * @property integer $id

 * @property string $request

 * @property string $response

 * @property string $log

 */

class LogActivities extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return LogActivities the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{log_Activities}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('request, response, log', 'required'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id, request, response, reference, log', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id' => 'ID',

			'request' => 'Request',

			'response' => 'Response',

			'reference' => 'Reference',

			'log' => 'Log',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);

		$criteria->compare('request',$this->request,true);

		$criteria->compare('response',$this->response,true);

		$criteria->compare('reference',$this->reference,true);

		$criteria->compare('log',$this->log,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}