<?php

/**
 * This is the model class for table "{{log_banco}}".
 *
 * The followings are the available columns in table '{{log_banco}}':
 * @property integer $id
 * @property string $header
 * @property string $request
 * @property string $response
 * @property string $reference
 * @property integer $id_recibo
 * @property string $reserva
 * @property string $log
 */
class LogBanco extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LogBanco the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{log_banco}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header, estatus', 'required'),
			array('id_recibo', 'numerical', 'integerOnly'=>true),
			array('reference', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, header, request, response, reference, id_recibo, estatus, tipo, reserva, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header' => 'Header',
			'estatus' => 'Estatus',
			'request' => 'Request',
			'response' => 'Response',
			'reference' => 'Reference',
			'id_recibo' => 'Id Recibo',
			'reserva' => 'Reserva',
			'tipo' => 'Tipo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('header',$this->header,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('request',$this->request,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('reserva',$this->reserva,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}