<?php

/**
 * This is the model class for table "{{log_ws}}".
 *
 * The followings are the available columns in table '{{log_ws}}':
 * @property integer $idLog
 * @property integer $id_log_ws
 * @property string $referencia
 * @property string $tipo
 * @property string $log
 */
class LogWs extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LogWs the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{log_ws}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_log_ws', 'required'),
			array('id_log_ws', 'numerical', 'integerOnly'=>true),
			array('referencia, tipo, ws', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idLog, id_log_ws, ws, referencia, tipo, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idLogHotel'=>array(self::BELONGS_TO, 'LogHotelBeds', 'id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idLog' => 'Id Log',
			'id_log_ws' => 'Id Log Ws',
			'ws' => 'Web Service',
			'referencia' => 'Referencia',
			'tipo' => 'Tipo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idLog',$this->idLog);
		$criteria->compare('id_log_ws',$this->id_log_ws);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('ws',$this->ws,true);
		$criteria->compare('log',$this->log,true);
		$criteria->order='log DESC';
		$criteria->limit=300;
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getId() {
 	 	return $this->id_log_ws;
	}
}