<?php

/**
 * This is the model class for table "MIT_Liga".
 *
 * The followings are the available columns in table 'MIT_Liga':
 * @property integer $id_MIT
 * @property string $referencia
 * @property double $importe
 * @property string $email
 * @property string $celular
 * @property integer $id_usuario
 * @property integer $banco
 * @property string $fecha_creacion
 * @property string $estatus
 * @property double $comision
 * @property double $importe_total
 * @property string $tipo
 */
class MITLiga extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MITLiga the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'MIT_Liga';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('referencia, importe, email, celular, id_usuario, banco,  estatus', 'required'),
			array('banco', 'numerical', 'integerOnly'=>true),
			array('importe, comision, importe_total', 'numerical'),
			array('referencia, email', 'length', 'max'=>255),
			array('celular', 'length', 'max'=>150),
			array('id_usuario', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>50),
			array('tipo', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_MIT, referencia, importe, email, celular, id_usuario, banco, fecha_creacion, estatus, comision, importe_total, tipo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_MIT' => 'ID',
			'referencia' => 'Referencia',
			'importe' => 'Importe',
			'email' => 'Email',
			'celular' => 'Celular',
			'id_usuario' => 'Usuario',
			'banco' => 'Banco',
			'fecha_creacion' => 'Fecha Creacion',
			'estatus' => 'Estatus',
			'comision' => 'Comision',
			'importe_total' => 'Importe Total',
			'tipo' => 'Tipo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_MIT',$this->id_MIT);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('celular',$this->celular,true);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('banco',$this->banco);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('importe_total',$this->importe_total);
		$criteria->compare('tipo',$this->tipo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array('defaultOrder'=>'fecha_creacion DESC'),
		));
	}
}