<?php

/**
 * This is the model class for table "MIT_Liga_Response".
 *
 * The followings are the available columns in table 'MIT_Liga_Response':
 * @property integer $id_MIT_Liga_Response
 * @property integer $id_MIT
 * @property string $Response
 * @property string $log
 * @property string $strResponse
 */
class MITLigaResponse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MITLigaResponse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'MIT_Liga_Response';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('log', 'required'),
			array('id_MIT', 'numerical', 'integerOnly'=>true),
			//array('Response, strResponse', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_MIT_Liga_Response, id_MIT, Response, log, strResponse', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_MIT_Liga_Response' => 'Id Mit Liga Response',
			'id_MIT' => 'Id Mit',
			'Response' => 'Response',
			'log' => 'Log',
			'strResponse' => 'Str Response',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_MIT_Liga_Response',$this->id_MIT_Liga_Response);
		$criteria->compare('id_MIT',$this->id_MIT);
		$criteria->compare('Response',$this->Response,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('strResponse',$this->strResponse,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}