<?php

/**
 * This is the model class for table "{{mega_grupos_bloqueos}}".
 *
 * The followings are the available columns in table '{{mega_grupos_bloqueos}}':
 * @property integer $id_grupos_bloqueos
 * @property integer $id_mega
 * @property string $id_bloqueo
 *
 * The followings are the available model relations:
 * @property Bloqueos $idBloqueo
 * @property MegaGrupos $idMega
 */
class MegaGruposBloqueos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MegaGruposBloqueos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mega_grupos_bloqueos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_mega, id_bloqueo', 'required'),
			array('id_mega', 'numerical', 'integerOnly'=>true),
			array('id_bloqueo', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_grupos_bloqueos, id_mega, id_bloqueo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'idMega' => array(self::BELONGS_TO, 'MegaGrupos', 'id_mega'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_grupos_bloqueos' => 'Id Grupos Bloqueos',
			'id_mega' => 'Id Mega',
			'id_bloqueo' => 'Id Bloqueo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_grupos_bloqueos',$this->id_grupos_bloqueos);
		$criteria->compare('id_mega',$this->id_mega);
		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}