<?php

/**
 * This is the model class for table "{{noches_gratis}}".
 *
 * The followings are the available columns in table '{{noches_gratis}}':
 * @property integer $id
 * @property string $id_tarifa
 * @property string $id_tipo_habitacion
 * @property integer $noche
 * @property integer $acumulable
 */
class NochesGratis extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return NochesGratis the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{noches_gratis}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, noche, acumulable', 'required'),
			array('id_tarifa, id_tipo_habitacion, noche, acumulable', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_tarifa, id_tipo_habitacion, noche, acumulable', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_tarifa' => 'Id Tarifa',
			'id_tipo_habitacion' => 'Tipo Habitación',
			'noche' => 'Noche Gratis',
			'acumulable' => 'Acumulable',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('noche',$this->noche);
		$criteria->compare('acumulable',$this->acumulable);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}