<?php

/**
 * This is the model class for table "{{nota_credito}}".
 *
 * The followings are the available columns in table '{{nota_credito}}':
 * @property string $id_nota_credito
 * @property double $importe
 * @property integer $id_agencia
 * @property string $id_ref
 * @property string $tipo_ref
 * @property string $concepto
 * @property string $observaciones
 * @property string $estatus
 * @property integer $id_user
 * @property string $fecha
 * @property string $fecha_aplicacion
 * @property string $fecha_cancelacion
 * @property string $motivo
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property Users $idUser
 */
class NotaCredito extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return NotaCredito the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{nota_credito}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tipo, importe, id_agencia, estatus, id_user', 'required'),
			array('id_tipo, id_agencia, id_banco, id_planpago, tarjeta, id_cuenta, id_user, revisado', 'numerical', 'integerOnly'=>true),
			array('importe, comision, total', 'numerical'),
			array('id_ref', 'length', 'max'=>10),
			array('tipo_ref, motivo', 'length', 'max'=>255),
			array('cliente, referencia', 'length', 'max'=>100),
			array('estatus', 'length', 'max'=>2),
			array('concepto, observaciones, fecha_aplicacion, fecha_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_nota_credito, id_tipo, importe, id_agencia, id_ref, tipo_ref, concepto, observaciones, estatus, id_user, fecha, fecha_aplicacion, fecha_cancelacion, motivo, revisado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipo'=> array(self::BELONGS_TO, 'TipoPago', 'id_tipo'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_nota_credito' => 'Id',
			'id_tipo' => 'Tipo de Pago',
			'importe' => 'Monto',
			'id_agencia' => 'Agencia',
			'id_ref' => 'Id Referencia',
			'tipo_ref' => 'Tipo Referencia',
			'cliente' => 'Cuenta Habiente',
			'referencia' => 'Referencia',
			'id_banco' => 'Banco',
			'id_planpago' => 'Plan Pago',
			'tarjeta' => '4 Dígitos',
			'id_cuenta' => 'Cuenta',
			'comision' => 'Comisión',
			'total' => 'Total',
			'concepto' => 'Concepto',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'id_user' => 'Elaboró',
			'fecha' => 'Fecha Creación',
			'fecha_aplicacion' => 'Fecha Aplicación',
			'fecha_cancelacion' => 'Fecha Cancelación',
			'motivo' => 'Motivo de Cancelación',
			'revisado' => 'Revisado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_nota_credito',$this->id_nota_credito,true);
		$criteria->compare('id_tipo',$this->id_tipo,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_ref',$this->id_ref,true);
		$criteria->compare('tipo_ref',$this->tipo_ref,true);
		$criteria->compare('concepto',$this->concepto,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('fecha_aplicacion',$this->fecha_aplicacion,true);
		$criteria->compare('fecha_cancelacion',$this->fecha_cancelacion,true);
		$criteria->compare('motivo',$this->motivo,true);
		if($_SESSION["tipoUsuario"] == "Agencia"){
			$criteria->addCondition('id_agencia='.$_SESSION["agenciaUsuario"].'))'); 
		}

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort' => array(
							'defaultOrder' => 'id_nota_credito DESC'
							)
		));
	}
}