<?php

/**
 * This is the model class for table "{{notificacion}}".
 *
 * The followings are the available columns in table '{{notificacion}}':
 * @property integer $id_notificacion
 * @property integer $id_item
 * @property integer $tipo
 * @property integer $id_users
 * @property integer $visto
 */
class Notificacion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Notificacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{notificacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_item, tipo, id_users, visto', 'required'),
			array('id_item, tipo, id_users, visto', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_notificacion, id_item, tipo, id_users, visto', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_notificacion' => 'Id Notificacion',
			'id_item' => 'Id Item',
			'tipo' => 'Tipo',
			'id_users' => 'Id Users',
			'visto' => 'Visto',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_notificacion',$this->id_notificacion);
		$criteria->compare('id_item',$this->id_item);
		$criteria->compare('tipo',$this->tipo);
		$criteria->compare('id_users',$this->id_users);
		$criteria->compare('visto',$this->visto);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}