<?php

/**
 * This is the model class for table "tbl_notificacion_pago".
 *
 * The followings are the available columns in table 'tbl_notificacion_pago':
 * @property integer $id_notificacion_pago
 * @property integer $id_tipo_pasarela
 * @property integer $payment_id
 * @property string $order_id
 * @property integer $id_agencia
 * @property string $log
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property Agencia $idAgencia
 * @property TiposPasarelas $idTipoPasarela
 */
class NotificacionPago extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_notificacion_pago';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tipo_pasarela, payment_id, order_id, id_agencia, log', 'required'),
			array('id_tipo_pasarela, payment_id, id_agencia, estatus', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_notificacion_pago, id_tipo_pasarela, payment_id, order_id, id_agencia, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idTipoPasarela' => array(self::BELONGS_TO, 'TiposPasarelas', 'id_tipo_pasarela'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_notificacion_pago' => 'Id Notificacion Pago',
			'id_tipo_pasarela' => 'Id Tipo Pasarela',
			'payment_id' => 'Payment',
			'order_id' => 'Order',
			'id_agencia' => 'Id Agencia',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_notificacion_pago',$this->id_notificacion_pago);
		$criteria->compare('id_tipo_pasarela',$this->id_tipo_pasarela);
		$criteria->compare('payment_id',$this->payment_id);
		$criteria->compare('order_id',$this->order_id,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return NotificacionPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
