<?php

/**
 * This is the model class for table "{{notificaciones_pago}}".
 *
 * The followings are the available columns in table '{{notificaciones_pago}}':
 * @property integer $id_notificacionPago
 * @property integer $id_recibo
 * @property integer $id_detalle
 * @property integer $id_users
 * @property integer $estado
 */
class NotificacionesPago extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return NotificacionesPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{notificaciones_pago}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_recibo, id_detalle, id_users, estado', 'required'),
			array('id_recibo, id_detalle, id_users, estado', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_notificacionPago, id_recibo, id_detalle, id_users, estado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_notificacionPago' => 'Id Notificacion Pago',
			'id_recibo' => 'Id Recibo',
			'id_detalle' => 'Id Detalle',
			'id_users' => 'Id Users',
			'estado' => 'Estado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_notificacionPago',$this->id_notificacionPago);
		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('id_detalle',$this->id_detalle);
		$criteria->compare('id_users',$this->id_users);
		$criteria->compare('estado',$this->estado);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}