<?php

/**
 * This is the model class for table "{{operaciones_log}}".
 *
 * The followings are the available columns in table '{{operaciones_log}}':
 * @property integer $id_operacion_log
 * @property integer $id_referencia
 * @property integer $id_operacion_tipo
 * @property integer $id_usuario
 * @property string $fecha_log
 *
 * The followings are the available model relations:
 * @property Users $idUsuario
 * @property OperacionesTipo $idOperacionTipo
 */
class OperacionesLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OperacionesLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{operaciones_log}}';
	}
	
	public $nombre_usuario;
	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_referencia, id_operacion_tipo, id_usuario', 'required'),
			array('id_referencia, id_operacion_tipo, id_usuario', 'numerical', 'integerOnly'=>true),
			array('descripcion', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_operacion_log, id_referencia, id_operacion_tipo, descripcion, nombre_usuario, fecha_log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario', 'with'=>'profiles'),
			'idOperacionTipo' => array(self::BELONGS_TO, 'OperacionesTipo', 'id_operacion_tipo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_operacion_log' => 'Id Operacion Log',
			'id_referencia' => 'Id Referencia',
			'id_operacion_tipo' => 'Tipo Operacion',
			'descripcion' => 'Pertenece a',
			'id_usuario' => 'Usuario',
			'fecha_log' => 'Fecha Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		$criteria->with='idUsuario';

		$criteria->compare('id_operacion_log',$this->id_operacion_log);
		$criteria->compare('id_referencia',$this->id_referencia);
		$criteria->compare('id_operacion_tipo',$this->id_operacion_tipo);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('CONCAT(firstname," ",lastname)',$this->nombre_usuario,true);
		$criteria->compare('fecha_log',$this->fecha_log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}