<?php

/**
 * This is the model class for table "{{ordenes_pago_detalles}}".
 *
 * The followings are the available columns in table '{{ordenes_pago_detalles}}':
 * @property integer $id_detalle_orden
 * @property string $id_reservacion
 * @property integer $id_orden_pago
 *
 * The followings are the available model relations:
 * @property Reservacion $idReservacion
 * @property OrdenesPago $idOrdenPago
 */
class OrdenesPagoDetalles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenesPagoDetalles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ordenes_pago_detalles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, id_orden_pago, importe', 'required'),
			array('id_orden_pago', 'numerical', 'integerOnly'=>true),
			array('id_reservacion', 'length', 'max'=>10),
			array('importe', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_detalle_orden, id_reservacion, id_orden_pago', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),
			'idOrdenPago' => array(self::BELONGS_TO, 'OrdenesPago', 'id_orden_pago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_detalle_orden' => 'No',
			'id_reservacion' => 'No Reservacion',
			'id_orden_pago' => 'No Orden Pago',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_detalle_orden',$this->id_detalle_orden);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_orden_pago',$this->id_orden_pago);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}