<?php

/**
 * This is the model class for table "{{pais}}".
 *
 * The followings are the available columns in table '{{pais}}':
 * @property integer $id_pais
 * @property integer $isonum_pais
 * @property string $iso2_pais
 * @property string $iso3_pais
 * @property string $nombre_pais
 */
class Pais extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Pais the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pais}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('isonum_pais', 'numerical', 'integerOnly'=>true),
			array('iso2_pais', 'length', 'max'=>2),
			array('iso3_pais', 'length', 'max'=>3),
			array('nombre_pais', 'length', 'max'=>80),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_pais, isonum_pais, iso2_pais, iso3_pais, nombre_pais', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pais' => 'Id Pais',
			'isonum_pais' => 'Isonum Pais',
			'iso2_pais' => 'Iso2 Pais',
			'iso3_pais' => 'Iso3 Pais',
			'nombre_pais' => 'Nombre Pais',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pais',$this->id_pais);
		$criteria->compare('isonum_pais',$this->isonum_pais);
		$criteria->compare('iso2_pais',$this->iso2_pais,true);
		$criteria->compare('iso3_pais',$this->iso3_pais,true);
		$criteria->compare('nombre_pais',$this->nombre_pais,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}