<?php

/**
 * This is the model class for table "{{participate_provider}}".
 *
 * The followings are the available columns in table '{{participate_provider}}':
 * @property integer $id_participate_provider
 * @property integer $id_evento
 * @property integer $id_proveedor
 * @property string $tipo_proveedor
 *
 * The followings are the available model relations:
 * @property Events $idEvento
 */
class ParticipateProvider extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ParticipateProvider the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{participate_provider}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_participate_provider, id_evento, id_proveedor, tipo_proveedor', 'required'),
			array('id_participate_provider, id_evento, id_proveedor', 'numerical', 'integerOnly'=>true),
			array('tipo_proveedor', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_participate_provider, id_evento, id_proveedor, tipo_proveedor', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idEvento' => array(self::BELONGS_TO, 'Events', 'id_evento'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_participate_provider' => 'Id Participate Provider',
			'id_evento' => 'Id Evento',
			'id_proveedor' => 'Id Proveedor',
			'tipo_proveedor' => 'Tipo Proveedor',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_participate_provider',$this->id_participate_provider);
		$criteria->compare('id_evento',$this->id_evento);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('tipo_proveedor',$this->tipo_proveedor,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}