<?php

/**
 * This is the model class for table "{{rates_estados}}".
 *
 * The followings are the available columns in table '{{rates_estados}}':
 * @property integer $id_restringir_estado
 * @property integer $id_rate_plan
 * @property string $id_estados
 * @property integer $estatus
 * @property integer $id_proveedor
 *
 * The followings are the available model relations:
 * @property Proveedores $idProveedor
 */
class RatesEstados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RatesEstados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{rates_estados}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_rate_plan, id_estados, id_proveedor', 'required'),
			array('id_rate_plan', 'unique'),
			array('id_rate_plan, estatus, id_proveedor', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_restringir_estado, id_rate_plan, id_estados, estatus, id_proveedor', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_restringir_estado' => 'Id Restringir Estado',
			'id_rate_plan' => 'Id Rate Plan',
			'id_estados' => 'Id Estados',
			'estatus' => 'Estatus',
			'id_proveedor' => 'Id Proveedor',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_restringir_estado',$this->id_restringir_estado);
		$criteria->compare('id_rate_plan',$this->id_rate_plan);
		$criteria->compare('id_estados',$this->id_estados,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('id_proveedor',$this->id_proveedor);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}