<?php



/**

 * This is the model class for table "{{recibo_detalles}}".

 *

 * The followings are the available columns in table '{{recibo_detalles}}':

 * @property integer $id_detalle

 * @property integer $id_recibo

 * @property integer $id_reservacion

 * @property integer $id_venta

 * @property string $concepto

 * @property double $importe

 */

class ReciboDetalles extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return ReciboDetalles the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{recibo_detalles}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_recibo, importe', 'required'),

			array('id_recibo, id_reservacion, id_venta', 'numerical', 'integerOnly'=>true),

			array('importe', 'numerical'),

			array('concepto', 'length', 'max'=>255),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_detalle, id_recibo, id_reservacion, id_venta, concepto, importe,tipo', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idRecibo' => array(self::BELONGS_TO, 'Recibo', 'id_recibo'),

			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),
			'idTourReservacion' => array(self::BELONGS_TO, 'TourReservacion', 'id_reservacion'),

			'idVenta' => array(self::BELONGS_TO, 'Venta', 'id_venta'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_detalle' => 'Id Detalle',

			'id_recibo' => 'Id Recibo',

			'id_reservacion' => 'Id Reservacion',

			'id_venta' => 'Id Venta',

			'concepto' => 'Concepto',

			'importe' => 'Importe',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_detalle',$this->id_detalle);

		$criteria->compare('id_recibo',$this->id_recibo);

		$criteria->compare('id_reservacion',$this->id_reservacion);

		$criteria->compare('id_venta',$this->id_venta);

		$criteria->compare('concepto',$this->concepto,true);

		$criteria->compare('importe',$this->importe);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}