<?php

/**
 * This is the model class for table "rentasv_anuncios".
 *
 * The followings are the available columns in table 'rentasv_anuncios':
 * @property integer $id_anuncio
 * @property integer $id_usuario
 * @property integer $id_espacio
 * @property integer $id_tipo_propiedad
 * @property integer $id_tipo_alojamiento
 * @property integer $id_datos_basicos
 * @property integer $id_politica_cancelacion
 * @property string $fecha_publicacion
 * @property string $estado
 * @property double $latitud
 * @property double $longitud
 *
 * The followings are the available model relations:
 * @property RentasvElementosSeguridad[] $rentasvElementosSeguridads
 * @property RentasvImagenes[] $rentasvImagenes
 * @property RentasvReglas[] $rentasvReglases
 * @property RentasvServiciosBasicos[] $rentasvServiciosBasicoses
 * @property RentasvServiciosEspeciales[] $rentasvServiciosEspeciales
 * @property RentasvDatosBasicos $idDatosBasicos
 * @property Users $idUsuario
 * @property RentasvDatosDeTuEspacio $idEspacio
 * @property RentasvTipoPropiedad $idTipoPropiedad
 * @property RentasvTipoAlojamiento $idTipoAlojamiento
 * @property RentasvPoliticaCancelacion $idPoliticaCancelacion
 */
class RentasvAnuncios extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentasv_anuncios';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario', 'required'),
			array('id_usuario, id_espacio, id_tipo_propiedad, id_tipo_alojamiento, id_datos_basicos, id_politica_cancelacion', 'numerical', 'integerOnly'=>true),
			array('latitud, longitud', 'numerical'),
			array('estado', 'length', 'max'=>8),
			array('fecha_publicacion', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_anuncio, id_usuario, id_espacio, id_tipo_propiedad, id_tipo_alojamiento, id_datos_basicos, id_politica_cancelacion, fecha_publicacion, estado, latitud, longitud', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rentasvElementosSeguridads' => array(self::MANY_MANY, 'RentasvElementosSeguridad', 'rentasv_anuncio_elemento_seguridad(id_anuncio, id_elemento_seguridad)'),
			'rentasvImagenes' => array(self::MANY_MANY, 'RentasvImagenes', 'rentasv_anuncio_imagen(id_anuncio, id_imagen)'),
			'rentasvReglases' => array(self::MANY_MANY, 'RentasvReglas', 'rentasv_anuncio_regla(id_anuncio, id_regla)'),
			'rentasvServiciosBasicoses' => array(self::MANY_MANY, 'RentasvServiciosBasicos', 'rentasv_anuncio_servicio_basico(id_anuncio, id_servicio_basico)'),
			'rentasvServiciosEspeciales' => array(self::MANY_MANY, 'RentasvServiciosEspeciales', 'rentasv_anuncio_servicio_especial(id_anuncio, id_servicio_especial)'),
			'idDatosBasicos' => array(self::BELONGS_TO, 'RentasvDatosBasicos', 'id_datos_basicos'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idEspacio' => array(self::BELONGS_TO, 'RentasvDatosDeTuEspacio', 'id_espacio'),
			'idTipoPropiedad' => array(self::BELONGS_TO, 'RentasvTipoPropiedad', 'id_tipo_propiedad'),
			'idTipoAlojamiento' => array(self::BELONGS_TO, 'RentasvTipoAlojamiento', 'id_tipo_alojamiento'),
			'idPoliticaCancelacion' => array(self::BELONGS_TO, 'RentasvPoliticaCancelacion', 'id_politica_cancelacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_anuncio' => 'Id Anuncio',
			'id_usuario' => 'Id Usuario',
			'id_espacio' => 'Id Espacio',
			'id_tipo_propiedad' => 'Id Tipo Propiedad',
			'id_tipo_alojamiento' => 'Id Tipo Alojamiento',
			'id_datos_basicos' => 'Id Datos Basicos',
			'id_politica_cancelacion' => 'Id Politica Cancelacion',
			'fecha_publicacion' => 'Fecha Publicacion',
			'estado' => 'Estado',
			'latitud' => 'Latitud',
			'longitud' => 'Longitud',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_anuncio',$this->id_anuncio);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_espacio',$this->id_espacio);
		$criteria->compare('id_tipo_propiedad',$this->id_tipo_propiedad);
		$criteria->compare('id_tipo_alojamiento',$this->id_tipo_alojamiento);
		$criteria->compare('id_datos_basicos',$this->id_datos_basicos);
		$criteria->compare('id_politica_cancelacion',$this->id_politica_cancelacion);
		$criteria->compare('fecha_publicacion',$this->fecha_publicacion,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('latitud',$this->latitud);
		$criteria->compare('longitud',$this->longitud);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasvAnuncios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
