<?php

/**
 * This is the model class for table "rentasv_datos_basicos".
 *
 * The followings are the available columns in table 'rentasv_datos_basicos':
 * @property integer $id_datos_basicos
 * @property integer $huespedes
 * @property integer $recamaras
 * @property integer $camas
 * @property integer $banos
 *
 * The followings are the available model relations:
 * @property RentasvAnuncios[] $rentasvAnuncioses
 */
class RentasvDatosBasicos extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentasv_datos_basicos';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('huespedes, recamaras, camas, banos', 'required'),
			array('huespedes, recamaras, camas, banos', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_datos_basicos, huespedes, recamaras, camas, banos', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rentasvAnuncioses' => array(self::HAS_MANY, 'RentasvAnuncios', 'id_datos_basicos'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_datos_basicos' => 'Id Datos Basicos',
			'huespedes' => 'Huespedes',
			'recamaras' => 'Recamaras',
			'camas' => 'Camas',
			'banos' => 'Banos',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_datos_basicos',$this->id_datos_basicos);
		$criteria->compare('huespedes',$this->huespedes);
		$criteria->compare('recamaras',$this->recamaras);
		$criteria->compare('camas',$this->camas);
		$criteria->compare('banos',$this->banos);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasvDatosBasicos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
