<?php

/**
 * This is the model class for table "{{reservacion_agencia_markup}}".
 *
 * The followings are the available columns in table '{{reservacion_agencia_markup}}':
 * @property integer $id
 * @property string $id_reservacion
 * @property double $total_modificado
 * @property double $saldo_modificado
 * @property double $markup
 * @property double $markup_rmt
 * @property string $tarifa
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Reservacion $idReservacion
 */
class ReservacionAgenciaMarkup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{reservacion_agencia_markup}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, total_modificado, saldo_modificado, markup, markup_rmt, tarifa', 'required'),
			array('total_modificado, saldo_modificado, markup, markup_rmt', 'numerical'),
			array('id_reservacion, tarifa', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, id_reservacion, total_modificado, saldo_modificado, markup, markup_rmt, tarifa, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_reservacion' => 'Id Reservacion',
			'total_modificado' => 'Total Modificado',
			'saldo_modificado' => 'Saldo Modificado',
			'markup' => 'Markup',
			'markup_rmt' => 'Markup Rmt',
			'tarifa' => 'Tarifa',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('total_modificado',$this->total_modificado);
		$criteria->compare('saldo_modificado',$this->saldo_modificado);
		$criteria->compare('markup',$this->markup);
		$criteria->compare('markup_rmt',$this->markup_rmt);
		$criteria->compare('tarifa',$this->tarifa,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ReservacionAgenciaMarkup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
