<?php

/**
 * This is the model class for table "{{reservacion_traslado}}".
 *
 * The followings are the available columns in table '{{reservacion_traslado}}':
 * @property integer $id_reservacion_traslado
 * @property string $referencia
 * @property string $name
 * @property string $lastname
 * @property string $email
 * @property string $phone
 * @property string $moneda
 * @property string $tipo_traslado
 * @property string $fecha_hora_recogida
 * @property string $fecha_hora_llegada
 * @property string $tipo_vehiculo
 * @property integer $numero_de_pasajeros
 * @property string $status
 * @property string $aeropuerto
 * @property string $hotel
 * @property double $precio_total
 * @property double $total_neto
 * @property string $fecha_creacion
 * @property string $codigo_vuelo_ida
 * @property string $hora_vuelo_ida
 * @property string $fecha_vuelo_ida
 * @property string $codigo_vuelo_regreso
 * @property string $hora_vuelo_regreso
 * @property string $fecha_vuelo_regreso
 * @property string $booking
 * @property string $vendedor_referenciado
 */
class ReservacionTraslado extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{reservacion_traslado}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('lastname, email, phone', 'required'),
			array('numero_de_pasajeros', 'numerical', 'integerOnly'=>true),
			array('precio_total, total_neto', 'numerical'),
			array('referencia, name, lastname, email, phone, moneda, tipo_traslado, tipo_vehiculo, status, aeropuerto, hotel, codigo_vuelo_ida, codigo_vuelo_regreso, vendedor_referenciado', 'length', 'max'=>255),
			array('fecha_hora_recogida, fecha_hora_llegada, fecha_creacion, hora_vuelo_ida, fecha_vuelo_ida, hora_vuelo_regreso, fecha_vuelo_regreso, booking', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_reservacion_traslado, referencia, name, lastname, email, phone, moneda, tipo_traslado, fecha_hora_recogida, fecha_hora_llegada, tipo_vehiculo, numero_de_pasajeros, status, aeropuerto, hotel, precio_total, total_neto, fecha_creacion, codigo_vuelo_ida, hora_vuelo_ida, fecha_vuelo_ida, codigo_vuelo_regreso, hora_vuelo_regreso, fecha_vuelo_regreso, booking, vendedor_referenciado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_reservacion_traslado' => 'Id Reservacion Traslado',
			'referencia' => 'Referencia',
			'name' => 'Name',
			'lastname' => 'Lastname',
			'email' => 'Email',
			'phone' => 'Phone',
			'moneda' => 'Moneda',
			'tipo_traslado' => 'Tipo Traslado',
			'fecha_hora_recogida' => 'Fecha Hora Recogida',
			'fecha_hora_llegada' => 'Fecha Hora Llegada',
			'tipo_vehiculo' => 'Tipo Vehiculo',
			'numero_de_pasajeros' => 'Numero De Pasajeros',
			'status' => 'Status',
			'aeropuerto' => 'Aeropuerto',
			'hotel' => 'Hotel',
			'precio_total' => 'Precio Total',
			'total_neto' => 'Total Neto',
			'fecha_creacion' => 'Fecha Creacion',
			'codigo_vuelo_ida' => 'Codigo Vuelo Ida',
			'hora_vuelo_ida' => 'Hora Vuelo Ida',
			'fecha_vuelo_ida' => 'Fecha Vuelo Ida',
			'codigo_vuelo_regreso' => 'Codigo Vuelo Regreso',
			'hora_vuelo_regreso' => 'Hora Vuelo Regreso',
			'fecha_vuelo_regreso' => 'Fecha Vuelo Regreso',
			'booking' => 'Booking',
			'vendedor_referenciado' => 'Vendedor Referenciado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_reservacion_traslado',$this->id_reservacion_traslado);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('lastname',$this->lastname,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('moneda',$this->moneda,true);
		$criteria->compare('tipo_traslado',$this->tipo_traslado,true);
		$criteria->compare('fecha_hora_recogida',$this->fecha_hora_recogida,true);
		$criteria->compare('fecha_hora_llegada',$this->fecha_hora_llegada,true);
		$criteria->compare('tipo_vehiculo',$this->tipo_vehiculo,true);
		$criteria->compare('numero_de_pasajeros',$this->numero_de_pasajeros);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('aeropuerto',$this->aeropuerto,true);
		$criteria->compare('hotel',$this->hotel,true);
		$criteria->compare('precio_total',$this->precio_total);
		$criteria->compare('total_neto',$this->total_neto);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('codigo_vuelo_ida',$this->codigo_vuelo_ida,true);
		$criteria->compare('hora_vuelo_ida',$this->hora_vuelo_ida,true);
		$criteria->compare('fecha_vuelo_ida',$this->fecha_vuelo_ida,true);
		$criteria->compare('codigo_vuelo_regreso',$this->codigo_vuelo_regreso,true);
		$criteria->compare('hora_vuelo_regreso',$this->hora_vuelo_regreso,true);
		$criteria->compare('fecha_vuelo_regreso',$this->fecha_vuelo_regreso,true);
		$criteria->compare('booking',$this->booking,true);
		$criteria->compare('vendedor_referenciado',$this->vendedor_referenciado,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ReservacionTraslado the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
