<?php



/**

 * This is the model class for table "{{roominglist}}".

 *

 * The followings are the available columns in table '{{roominglist}}':

 * @property integer $id

 * @property string $id_bloqueo

 * @property string $nombre

 * @property string $id_base_habitacion

 * @property string $id_reservacion

 * @property double $importe

 *

 * The followings are the available model relations:

 * @property Reservacion $idReservacion

 * @property Bloqueos $idBloqueo

 * @property BaseHabitacion $idBaseHabitacion

 */

class Roominglist extends CActiveRecord

{

	public $saldo;
	public $abono;
	public $total;

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Roominglist the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{roominglist}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_bloqueo, habitacion', 'required'),

			array('anticipo, importe', 'numerical'),

			array('confirmado', 'numerical', 'integerOnly'=>true),

			array('id_bloqueo, id_agencia, id_base_habitacion, noches', 'length', 'max'=>10),
			
			array('id_reservacion', 'length', 'max'=>11),

			array('nombre, menor, edad', 'length', 'max'=>255),

			array('fecha_inicio, fecha_final, fecha_limite, observaciones', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id, id_bloqueo, id_agencia, nombre, menor, edad, id_base_habitacion, fecha_inicio, fecha_final, noches, id_reservacion, anticipo, importe, fecha_apartado, fecha_limite, estatus, observaciones, confirmado', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),

			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),

			'idBaseHabitacion' => array(self::BELONGS_TO, 'BaseHabitacion', 'id_base_habitacion'),

			'anticipos' => array(self::HAS_MANY, 'RoominglistAnticipo', 'id_roominglist'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id' => 'ID',

			'habitacion' => 'Habitación',

			'id_bloqueo' => 'Bloqueo',

			'id_agencia' => 'Agencia',

			'nombre' => 'Nombre',

			'menor' => 'Menor',

			'edad' => 'Edad',

			'id_base_habitacion' => 'Id Base Habitacion',

			'fecha_inicio' => 'fecha_inicio',

			'fecha_final' => 'fecha_final',

			'noches' => 'Noches',

			'id_reservacion' => 'Id Reservacion',

			'anticipo' => 'Anticipo',

			'importe' => 'Importe',

			'fecha_apartado' => 'Fecha Apartado',

			'fecha_limite' => 'Fecha Límite',

			'estatus' => 'Estatus',

			'observaciones' => 'Observaciones',

			'confirmado' => 'Confirmado',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id',$this->id);

		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('menor',$this->menor,true);

		$criteria->compare('edad',$this->edad,true);

		$criteria->compare('id_base_habitacion',$this->id_base_habitacion,true);

		$criteria->compare('id_reservacion',$this->id_reservacion,true);

		$criteria->compare('importe',$this->importe);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

	

	public function getFullEstatus($estatus)

	{

		if($estatus == "D"){

			return "Disponible";

		}else if($estatus == "ND"){

			return "No Disponible";

		}else

			return "Vencida";

	}

}