<?php

/**
 * This is the model class for table "{{roominglist_anticipo}}".
 *
 * The followings are the available columns in table '{{roominglist_anticipo}}':
 * @property integer $id_roominglist
 * @property integer $id_nota_credito
 * @property double $importe
 */
class RoominglistAnticipo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RoominglistAnticipo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{roominglist_anticipo}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_roominglist, id_nota_credito, importe', 'required'),
			array('id_roominglist, id_nota_credito', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_roominglist, id_nota_credito, importe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idNotaCredito' => array(self::BELONGS_TO, 'NotaCredito', 'id_nota_credito'),
			'idRoominglist' => array(self::BELONGS_TO, 'Roominglist', 'id_roominglist'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_roominglist' => 'Id Roominglist',
			'id_nota_credito' => 'Id Nota Credito',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_roominglist',$this->id_roominglist);
		$criteria->compare('id_nota_credito',$this->id_nota_credito);
		$criteria->compare('importe',$this->importe);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}