<?php

/**
 * This is the model class for table "{{saldo_hotel}}".
 *
 * The followings are the available columns in table '{{saldo_hotel}}':
 * @property integer $id_saldo_h
 * @property string $codigo
 * @property double $saldo_h
 * @property string $proveedor
 * @property integer $estatus
 */
class SaldoHotel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SaldoHotel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{saldo_hotel}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('codigo, saldo_h, proveedor', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('saldo_h', 'numerical'),
			array('codigo', 'length', 'max'=>155),
			array('proveedor', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_saldo_h, codigo, saldo_h, proveedor, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_saldo_h' => 'Id Saldo H',
			'codigo' => 'Codigo',
			'saldo_h' => 'Saldo H',
			'proveedor' => 'Proveedor',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_saldo_h',$this->id_saldo_h);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('saldo_h',$this->saldo_h);
		$criteria->compare('proveedor',$this->proveedor,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}