<?php

/**
 * This is the model class for table "tbl_seccion_menu".
 *
 * The followings are the available columns in table 'tbl_seccion_menu':
 * @property integer $id_seccion_menu
 * @property integer $posicion
 * @property integer $id_seccion
 * @property integer $id_agencia
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Seccion $idSeccion
 * @property Agencia $idAgencia
 */
class SeccionMenu extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_seccion_menu';
	}
	public function getDbConnection()
	{
		return Yii::app()->db2;
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('posicion, id_seccion, id_agencia, log', 'required'),
			array('posicion, id_seccion, id_agencia', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_seccion_menu, posicion, id_seccion, id_agencia, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idSeccion' => array(self::BELONGS_TO, 'Secciones', 'id_seccion'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_seccion_menu' => 'Id Seccion Menu',
			'posicion' => 'Posicion',
			'id_seccion' => 'Id Seccion',
			'id_agencia' => 'Id Agencia',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_seccion_menu',$this->id_seccion_menu);
		$criteria->compare('posicion',$this->posicion);
		$criteria->compare('id_seccion',$this->id_seccion);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SeccionMenu the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
