<?php

/**
 * This is the model class for table "tbl_secciones".
 *
 * The followings are the available columns in table 'tbl_secciones':
 * @property integer $id
 * @property string $secciones
 * @property string $contenido
 * @property string $custom_css
 * @property string $custom_js
 * @property string $creado
 * @property integer $estatus
 * @property integer $posicion
 */
class Secciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Secciones the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
	public function getDbConnection()
	{
		return Yii::app()->db2;
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_secciones';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('secciones', 'required'),
			array('estatus', 'numerical', 'integerOnly' => true),
			array('secciones', 'length', 'max' => 255),
			array('contenido, custom_css, custom_js', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_seccion, secciones, foto_destacada, contenido, custom_css, custom_js, creado, estatus', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			// 'subsecciones' => array(self::HAS_MANY, 'Subsecciones', 'id_seccion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_seccion' => 'ID',
			'secciones' => 'Secciones',
			'foto_destacada' => 'Foto Destacada',
			'contenido' => 'Contenido',
			'custom_css' => 'Css Personalizado',
			'custom_js' => 'Js Personalizado',
			'creado' => 'Creado',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id_seccion', $this->id);
		$criteria->compare('secciones', $this->secciones, true);
		$criteria->compare('foto_destacada', $this->foto_destacada, true);
		$criteria->compare('contenido', $this->contenido, true);
		$criteria->compare('custom_css', $this->custom_css, true);
		$criteria->compare('custom_js', $this->custom_js, true);
		$criteria->compare('creado', $this->creado, true);
		$criteria->compare('estatus', $this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}
