<?php

/**
 * This is the model class for table "{{solicitud_reservacion_desglose_persona}}".
 *
 * The followings are the available columns in table '{{solicitud_reservacion_desglose_persona}}':
 * @property string $nombre
 * @property string $tipo
 * @property integer $edad
 * @property string $log
 * @property string $id_desglose
 * @property string $id_desglose_persona
 * @property string $id_reservacion
 */
class SolicitudReservacionDesglosePersona extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SolicitudReservacionDesglosePersona the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{solicitud_reservacion_desglose_persona}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array(' id_desglose, id_reservacion', 'required'),
			array('edad', 'numerical', 'integerOnly'=>true),
			array('nombre', 'length', 'max'=>255),
			array('tipo', 'length', 'max'=>1),
			array('id_desglose, id_reservacion', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('nombre, tipo, edad, log, id_desglose, id_desglose_persona, id_reservacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'nombre' => 'Nombre',
			'tipo' => 'Tipo',
			'edad' => 'Edad',
			'log' => 'Log',
			'id_desglose' => 'Id Desglose',
			'id_desglose_persona' => 'Id Desglose Persona',
			'id_reservacion' => 'Id Reservacion',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('edad',$this->edad);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_desglose',$this->id_desglose,true);
		$criteria->compare('id_desglose_persona',$this->id_desglose_persona,true);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}