<?php

/**
 * This is the model class for table "tbl_solicitudes_tours".
 *
 * The followings are the available columns in table 'tbl_solicitudes_tours':
 * @property integer $id_solicitud
 * @property integer $id_tour
 * @property integer $id_agencia_rmt
 * @property integer $id_usuario_creo
 * @property string $fecha_solicitud
 * @property string $log
 */
class SolicitudesTours extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_solicitudes_tours';
	}

	public function getDbConnection()
	{
		return Yii::app()->db3;
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tour, id_agencia_rmt, id_usuario_creo, fecha_solicitud', 'required'),
			array('id_tour, id_agencia_rmt, id_usuario_creo', 'numerical', 'integerOnly'=>true),
			array('log', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_solicitud, id_tour, id_agencia_rmt, id_usuario_creo, fecha_solicitud, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_solicitud' => 'Id Solicitud',
			'id_tour' => 'Id Tour',
			'id_agencia_rmt' => 'Id Agencia Rmt',
			'id_usuario_creo' => 'Id Usuario Creo',
			'fecha_solicitud' => 'Fecha Solicitud',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_solicitud',$this->id_solicitud);
		$criteria->compare('id_tour',$this->id_tour);
		$criteria->compare('id_agencia_rmt',$this->id_agencia_rmt);
		$criteria->compare('id_usuario_creo',$this->id_usuario_creo);
		$criteria->compare('fecha_solicitud',$this->fecha_solicitud,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SolicitudesTours the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
