
<?php

/**
 * This is the model class for table "tbl_subseccion".
 *
 * The followings are the available columns in table 'tbl_subseccion':
 * @property integer $id
 * @property string $nombre
 * @property string $foto_destacada
 * @property string $contenido
 * @property string $custom_css
 * @property string $custom_js
 * @property string $custom_url
 * @property string $slug
 * @property string $creado
 * @property integer $estatus
 * @property integer $posicion
 * @property integer $portada
 * @property integer $id_seccion
 * @property integer $id_agencia
 *
 * The followings are the available model relations:
 * @property Seccion $idSeccion
 * @property Agencia $idAgencia
 */
class Subseccion extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'tbl_subseccion';
    }

	public function getDbConnection()
	{
		return Yii::app()->db3;
	}

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('nombre, creado, id_agencia', 'required'),
            array('estatus, posicion, portada, id_seccion, id_agencia', 'numerical', 'integerOnly'=>true),
            array('nombre, slug', 'length', 'max'=>255),
            array('foto_destacada, contenido, custom_css, custom_js, custom_url', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, nombre, foto_destacada, contenido, custom_css, custom_js, custom_url, slug, creado, estatus, posicion, portada, id_seccion, id_agencia', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idSeccion' => array(self::BELONGS_TO, 'Seccion', 'id_seccion'),
            'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'nombre' => 'Nombre',
            'foto_destacada' => 'Foto Destacada',
            'contenido' => 'Contenido',
            'custom_css' => 'Custom Css',
            'custom_js' => 'Custom Js',
            'custom_url' => 'Custom Url',
            'slug' => 'Slug',
            'creado' => 'Creado',
            'estatus' => 'Estatus',
            'posicion' => 'Posicion',
            'portada' => 'Portada',
            'id_seccion' => 'Id Seccion',
            'id_agencia' => 'Id Agencia',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('nombre',$this->nombre,true);
        $criteria->compare('foto_destacada',$this->foto_destacada,true);
        $criteria->compare('contenido',$this->contenido,true);
        $criteria->compare('custom_css',$this->custom_css,true);
        $criteria->compare('custom_js',$this->custom_js,true);
        $criteria->compare('custom_url',$this->custom_url,true);
        $criteria->compare('slug',$this->slug,true);
        $criteria->compare('creado',$this->creado,true);
        $criteria->compare('estatus',$this->estatus);
        $criteria->compare('posicion',$this->posicion);
        $criteria->compare('portada',$this->portada);
        $criteria->compare('id_seccion',$this->id_seccion);
        $criteria->compare('id_agencia',$this->id_agencia);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Subseccion the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}