<?php

/**
 * This is the model class for table "tbl_subsecciones".
 *
 * The followings are the available columns in table 'tbl_subsecciones':
 * @property integer $id
 * @property string $nombre
 * @property string $contenido
 * @property string $custom_css
 * @property string $custom_js
 * @property string $custom_url
 * @property integer $posicion
 * @property integer $id_seccion
 * @property string $creado
 * @property integer $estatus
 */
class Subsecciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Subsecciones the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */

	public function getDbConnection()
	{
		return Yii::app()->db2;
	}
	
	public function tableName()
	{
		return 'tbl_subsecciones';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre', 'required'),
			array('posicion, id_seccion, estatus', 'numerical', 'integerOnly' => true),
			array('nombre', 'length', 'max' => 255),
			array('contenido, custom_css, custom_js, custom_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, nombre, contenido, custom_css, custom_js, custom_url, posicion, id_seccion, creado, estatus', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idSeccion' => array(self::BELONGS_TO, 'Secciones', 'id_seccion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'nombre' => 'Nombre',
			'contenido' => 'Contenido',
			'custom_css' => 'Css Personalizado',
			'custom_js' => 'Js Personalizado',
			'custom_url' => 'URL',
			'posicion' => 'Posicion',
			'id_seccion' => 'Secciones',
			'creado' => 'Creado',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nombre', $this->nombre, true);
		$criteria->compare('contenido', $this->contenido, true);
		$criteria->compare('custom_css', $this->custom_css, true);
		$criteria->compare('custom_js', $this->custom_js, true);
		$criteria->compare('custom_url', $this->custom_url, true);
		$criteria->compare('posicion', $this->posicion);
		$criteria->compare('id_seccion', $this->id_seccion);
		$criteria->compare('creado', $this->creado, true);
		$criteria->compare('estatus', $this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}
