<?php

/**
 * This is the model class for table "{{sucursales}}".
 *
 * The followings are the available columns in table '{{sucursales}}':
 * @property string $id_sucursal
 * @property string $nombre
 * @property string $direccion
 * @property string $telefonos
 * @property string $descripcion
 * @property string $representante
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property SucursalesEstados[] $sucursalesEstadoses
 */
class Sucursales extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Sucursales the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sucursales}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, estatus', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('nombre', 'length', 'max'=>50),
			array('direccion', 'length', 'max'=>255),
			array('telefonos, representante', 'length', 'max'=>100),
			array('descripcion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_sucursal, nombre, direccion, telefonos, descripcion, representante, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'sucursalesEstadoses' => array(self::HAS_MANY, 'SucursalesEstados', 'id_sucursal'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_sucursal' => 'Id Sucursal',
			'nombre' => 'Nombre',
			'direccion' => 'Direccion',
			'telefonos' => 'Telefonos',
			'descripcion' => 'Descripcion',
			'representante' => 'Representante',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_sucursal',$this->id_sucursal,true);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('telefonos',$this->telefonos,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('representante',$this->representante,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}