<?php

/**
 * This is the model class for table "{{tarifa_estados}}".
 *
 * The followings are the available columns in table '{{tarifa_estados}}':
 * @property integer $id_tarifa_estado
 * @property string $id_tarifa
 * @property integer $id_estado
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Tarifa $idTarifa
 * @property Estadosmex $idEstado
 */
class TarifaEstados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TarifaEstados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tarifa_estados}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, id_estado', 'required'),
			array('id_tarifa_estado, id_estado', 'numerical', 'integerOnly'=>true),
			array('id_tarifa', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifa_estado, id_tarifa, id_estado, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
			'idEstado' => array(self::BELONGS_TO, 'Estadosmex', 'id_estado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifa_estado' => 'Id Tarifa Estado',
			'id_tarifa' => 'Id Tarifa',
			'id_estado' => 'Id Estado',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tarifa_estado',$this->id_tarifa_estado);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('id_estado',$this->id_estado);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}