<?php

/**
 * This is the model class for table "{{tarifas_flyers}}".
 *
 * The followings are the available columns in table '{{tarifas_flyers}}':
 * @property string $id_tarifaFlyer
 * @property string $id_tarifa_desglose
 * @property string $log
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property TarifaDesglose $idTarifaDesglose
 */
class TarifasFlyers extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TarifasFlyers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tarifas_flyers}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa_desglose', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('id_tarifa_desglose', 'length', 'max'=>10),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifaFlyer, id_tarifa_desglose, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTarifaDesglose' => array(self::BELONGS_TO, 'TarifaDesgloseRest', 'id_tarifa_desglose'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifaFlyer' => 'Id Tarifa Flyer',
			'id_tarifa_desglose' => 'Id Tarifa Desglose',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tarifaFlyer',$this->id_tarifaFlyer,true);
		$criteria->compare('id_tarifa_desglose',$this->id_tarifa_desglose,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}