<?php



/**

 * This is the model class for table "{{tipo_habitaciones}}".

 *

 * The followings are the available columns in table '{{tipo_habitaciones}}':

 * @property string $id_tipo_habitacion

 * @property string $tipo_habitacion

 * @property string $descripcion

 * @property integer $estatus

 * @property string $log

 * @property string $id_hotel

 *

 * The followings are the available model relations:

 * @property ReservacionDesglose[] $reservacionDesgloses

 * @property TarifaDesglose[] $tarifaDesgloses

 */

class TipoHabitaciones extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return TipoHabitaciones the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tipo_habitaciones}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('tipo_habitacion, id_hotel', 'required'),

			array('max_adultos, max_menores, max_juniors, paxextra, estatus, activa_validacion, orden', 'numerical', 'integerOnly'=>true),

			array('tipo_habitacion', 'length', 'max'=>255),

			array('id_hotel', 'length', 'max'=>10),

			array('codigo', 'length', 'max'=>15),

			array('descripcion','safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tipo_habitacion, tipo_habitacion, descripcion, max_adultos, max_menores, max_juniors, paxextra, estatus, log, id_hotel, activa_validacion, orden', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'reservacionDesgloses' => array(self::HAS_MANY, 'ReservacionDesglose', 'id_tipo_habitacion'),

			'tarifaDesgloses' => array(self::HAS_MANY, 'TarifaDesglose', 'id_tipo_habitacion', 'joinType'=>'INNER JOIN'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tipo_habitacion' => 'Id Tipo Habitación',

			'tipo_habitacion' => 'Tipo Habitación',

			'descripcion' => 'Descripción',

			'codigo' => 'Código',

			'max_adultos' => 'Max Adultos',

			'max_menores' => 'Max Menores',

			'max_juniors' => 'Max Juniors',

			'paxextra' => 'Pax. Extra',

			'estatus' => 'Estatus',

			'log' => 'Log',

			'id_hotel' => 'Id Hotel',

			'orden' => 'Orden',

			'activa_validacion' => 'Activa Validacion',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);

		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);

		$criteria->compare('descripcion',$this->descripcion,true);

		$criteria->compare('max_adultos',$this->max_adultos);

		$criteria->compare('max_menores',$this->max_menores);

		$criteria->compare('max_juniors',$this->max_juniors);

		$criteria->compare('paxextra',$this->paxextra);

		$criteria->compare('estatus',$this->estatus);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('id_hotel',$this->id_hotel,true);

		$criteria->compare('activa_validacion',$this->activa_validacion);

		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}