<?php

/**
 * This is the model class for table "{{tipo_pago}}".
 *
 * The followings are the available columns in table '{{tipo_pago}}':
 * @property integer $id_tipo
 * @property string $descripcion
 * @property string $comision
 * @property string $tipo_monto
 */
class TipoPago extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TipoPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tipo_pago}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, comision, tipo_monto', 'required'),
			array('comision', 'length', 'max'=>12),
			array('tipo_monto', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tipo, descripcion, comision, tipo_monto', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tipo' => 'Id Tipo',
			'descripcion' => 'Descripcion',
			'comision' => 'Comision',
			'tipo_monto' => 'Tipo Monto',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tipo',$this->id_tipo);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('comision',$this->comision,true);
		$criteria->compare('tipo_monto',$this->tipo_monto,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}