<?php



/**

 * This is the model class for table "{{tour}}".

 *

 * The followings are the available columns in table '{{tour}}':

 * @property integer $id_tour

 * @property string $nombre

 * @property string $nombre_en

 * @property string $descripcion_corta

 * @property string $descripcion_corta_en

 * @property string $descripcion

 * @property string $descripcion_en

 * @property integer $incluye_hab

 * @property string $adicional

 * @property string $adicional_en

 * @property integer $idTipoCategoria

 * @property integer $id_destino

 * @property string $map_markers

 * @property int $estatus

 *

 * The followings are the available model relations:

 * @property TipoCategoria $idTipoCategoria0

 * @property TourReservacion[] $tourReservacions

 * @property TourTarifa[] $tourTarifas

 */

class Tour extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Tour the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tour}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('nombre, idTipoCategoria, id_destino', 'required'),

			array('idTipoCategoria, id_destino, estatus, incluye_hab', 'numerical', 'integerOnly'=>true),

			array('nombre, nombre_en', 'length', 'max'=>255),

			array('map_markers', 'length', 'max'=>1000),

			array('descripcion_corta, descripcion_corta_en, descripcion, descripcion_en, adicional, adicional_en', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tour, nombre, nombre_en, descripcion_corta, descripcion_corta_en, descripcion, descripcion_en, adicional, adicional_en, incluye_hab, idTipoCategoria, id_destino, map_markers, estatus', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idTipoCategoria0' => array(self::BELONGS_TO, 'TipoCategoria', 'idTipoCategoria'),

			'tourReservacions' => array(self::HAS_MANY, 'TourReservacion', 'id_tour'),

			'tourTarifas' => array(self::HAS_MANY, 'TourTarifa', 'id_tour'),

			'idDestino' => array(self::BELONGS_TO, 'DestinosTours', 'id_destino'),

			'fechasTour' => array(self::HAS_MANY, 'TourTarifaFechas', 'id_tour')

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tour' => 'Id Tour',

			'nombre' => 'Nombre',

			'nombre_en' => 'Nombre En',

			'descripcion_corta' => 'Descripcion Corta',

			'descripcion_corta_en' => 'Descripcion Corta En',

			'descripcion' => 'Descripcion',

			'descripcion_en' => 'Descripcion En',

			'adicional' => 'Adicional',

			'adicional_en' => 'Adicional En',

			'incluye_hab' => 'Incluye Habitación',

			'idTipoCategoria' => 'Id Tipo Cateogria',

			'id_destino' => 'Id Destino',

			'map_markers' => 'Map Markers',

			'estatus' => 'Estatus',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tour',$this->id_tour);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('nombre_en',$this->nombre_en,true);

		$criteria->compare('descripcion_corta',$this->descripcion_corta,true);

		$criteria->compare('descripcion_corta_en',$this->descripcion_corta_en,true);

		$criteria->compare('descripcion',$this->descripcion,true);

		$criteria->compare('descripcion_en',$this->descripcion_en,true);

		$criteria->compare('adicional',$this->adicional,true);

		$criteria->compare('adicional_en',$this->adicional_en,true);

		$criteria->compare('incluye_hab',$this->adicional_en,true);

		$criteria->compare('idTipoCategoria',$this->idTipoCategoria);

		$criteria->compare('id_destino',$this->id_destino);

		$criteria->compare('map_markers',$this->map_markers,true);

		$criteria->compare('estatus',$this->estatus,true);

		//$criteria->addCondition('estatus=1');


		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}