<?php

/**
 * This is the model class for table "tbl_transacciones_getnet".
 *
 * The followings are the available columns in table 'tbl_transacciones_getnet':
 * @property integer $id_pago
 * @property integer $id_agencia
 * @property string $referencia_pago
 * @property string $url_pago
 * @property string $respuesta
 * @property double $monto
 * @property string $estatus_transaccion
 * @property string $log
 */
class TransaccionesGetnet extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_transacciones_getnet';
	}

	public function getDbConnection()
	{
		return Yii::app()->db3;
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('monto', 'numerical'),
			array('referencia_pago, estatus_transaccion', 'length', 'max'=>50),
			array('url_pago', 'length', 'max'=>255),
			array('respuesta, log', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_pago, id_agencia, referencia_pago, url_pago, respuesta, monto, estatus_transaccion, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pago' => 'Id Pago',
			'id_agencia' => 'Id Agencia',
			'referencia_pago' => 'Referencia Pago',
			'url_pago' => 'Url Pago',
			'respuesta' => 'Respuesta',
			'monto' => 'Monto',
			'estatus_transaccion' => 'Estatus Transaccion',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pago',$this->id_pago);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('referencia_pago',$this->referencia_pago,true);
		$criteria->compare('url_pago',$this->url_pago,true);
		$criteria->compare('respuesta',$this->respuesta,true);
		$criteria->compare('monto',$this->monto);
		$criteria->compare('estatus_transaccion',$this->estatus_transaccion,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TransaccionesGetnet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
