<?php

/**
 * This is the model class for table "transacciones_openpay".
 *
 * The followings are the available columns in table 'transacciones_openpay':
 * @property integer $id
 * @property string $id_transaccion
 * @property string $codigo_verificacion
 * @property string $estatus
 * @property string $url_redirect
 * @property integer $error_code
 * @property string $log
 */
class TransaccionesOpenpay extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'transacciones_openpay';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('error_code', 'numerical', 'integerOnly'=>true),
			array('id_transaccion', 'length', 'max'=>255),
			array('codigo_verificacion, estatus', 'length', 'max'=>50),
			array('url_redirect', 'length', 'max'=>150),
			array('log', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, id_transaccion, codigo_verificacion, estatus, url_redirect, error_code, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_transaccion' => 'Id Transaccion',
			'codigo_verificacion' => 'Codigo Verificacion',
			'estatus' => 'Estatus',
			'url_redirect' => 'Url Redirect',
			'error_code' => 'Error Code',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_transaccion',$this->id_transaccion,true);
		$criteria->compare('codigo_verificacion',$this->codigo_verificacion,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('url_redirect',$this->url_redirect,true);
		$criteria->compare('error_code',$this->error_code);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TransaccionesOpenpay the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
