<?php

/**
 * This is the model class for table "{{transportacion_reservacion}}".
 *
 * The followings are the available columns in table '{{transportacion_reservacion}}':
 * @property string $id_reservacion
 * @property integer $id_agencia
 * @property string $id_hotel
 * @property integer $id_usuario
 * @property integer $id_agente
 * @property string $fecha_llegada
 * @property string $hora_vuelo_llegada
 * @property string $aerolinea_llegada
 * @property string $num_vuelo_llegada
 * @property string $fecha_salida
 * @property string $hora_pick_up
 * @property string $hora_vuelo_salida
 * @property string $aerolinea_salida
 * @property string $num_vuelo_salida
 * @property integer $servicio
 * @property integer $deluxe
 * @property integer $pasajeros
 * @property string $fecha_limite
 * @property string $fecha_limite_api
 * @property string $observaciones
 * @property string $estatus
 * @property string $log
 * @property double $comision
 * @property double $tipo_cambio
 * @property double $total
 * @property double $total_tc
 * @property double $saldo
 * @property double $saldo_api
 * @property double $tarifa_agencia
 * @property double $tarifa_neta
 * @property string $moneda
 * @property string $nombre_cliente
 * @property string $apellido_cliente
 * @property string $tel_cliente
 * @property string $email
 * @property integer $id_estado
 * @property string $ciudad
 * @property string $code
 * @property string $motivo
 * @property string $politicas_cancelacion
 * @property string $desglose_rate
 */
class TransportacionReservacion extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{transportacion_reservacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, id_hotel, id_usuario, servicio, deluxe, direccion, pasajeros, estatus, comision, total, total_tc, saldo, saldo_api, nombre_cliente, apellido_cliente', 'required'),
			array('id_agencia, id_usuario, id_agente, servicio, deluxe, direccion, pasajeros, id_estado', 'numerical', 'integerOnly'=>true),
			array('comision, tipo_cambio, total, total_tc, saldo, saldo_api, tarifa_agencia, tarifa_neta', 'numerical'),
			array('id_hotel', 'length', 'max'=>11),
			array('aerolinea_llegada, num_vuelo_llegada, aerolinea_salida, num_vuelo_salida, nombre_cliente, apellido_cliente, email, ciudad, code', 'length', 'max'=>255),
			array('estatus', 'length', 'max'=>3),
			array('moneda', 'length', 'max'=>10),
			array('tel_cliente', 'length', 'max'=>45),
			array('hora_vuelo_llegada, fecha_salida, hora_pick_up, hora_vuelo_salida, fecha_limite, fecha_limite_api, observaciones, motivo, politicas_cancelacion, desglose_rate', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_reservacion, id_agencia, id_hotel, id_usuario, id_agente, fecha_llegada, hora_vuelo_llegada, aerolinea_llegada, num_vuelo_llegada, fecha_salida, hora_pick_up, hora_vuelo_salida, aerolinea_salida, num_vuelo_salida, servicio, deluxe, direccion, pasajeros, fecha_limite, fecha_limite_api, observaciones, estatus, log, comision, tipo_cambio, total, total_tc, saldo, saldo_api, tarifa_agencia, tarifa_neta, moneda, nombre_cliente, apellido_cliente, tel_cliente, email, id_estado, ciudad, code, motivo, politicas_cancelacion, desglose_rate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idAgente' => array(self::BELONGS_TO, 'Usuarios', 'id_agente'),
			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'hotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idEstado' => array(self::BELONGS_TO, 'Estadosmex', 'id_estado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_reservacion' => 'Id Reservacion',
			'id_agencia' => 'Id Agencia',
			'id_hotel' => 'Id Hotel',
			'id_usuario' => 'Id Usuario',
			'id_agente' => 'Id Agente',
			'fecha_llegada' => 'Fecha Llegada',
			'hora_vuelo_llegada' => 'Hora Vuelo Llegada',
			'aerolinea_llegada' => 'Aerolinea Llegada',
			'num_vuelo_llegada' => 'Num Vuelo Llegada',
			'fecha_salida' => 'Fecha Salida',
			'hora_pick_up' => 'Hora Pick Up',
			'hora_vuelo_salida' => 'Hora Vuelo Salida',
			'aerolinea_salida' => 'Aerolinea Salida',
			'num_vuelo_salida' => 'Num Vuelo Salida',
			'servicio' => 'Servicio','0 = sencillo, 1 = redondo',
			'deluxe' => 'Deluxe','0 = regular, 1 = deluxe',
			'direccion' => '0: \'Aeropuerto-Hotel\', 1: \'Hotel-Aeropuerto\'',
			'pasajeros' => 'Pasajeros',
			'fecha_limite' => 'Fecha Limite',
			'fecha_limite_api' => 'Fecha Limite Api',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'comision' => 'Comision',
			'tipo_cambio' => 'Tipo Cambio',
			'total' => 'Total',
			'total_tc' => 'Total Tc',
			'saldo' => 'Saldo',
			'saldo_api' => 'Saldo Api',
			'tarifa_agencia' => 'Tarifa Agencia',
			'tarifa_neta' => 'Tarifa Neta',
			'moneda' => 'Moneda',
			'nombre_cliente' => 'Nombre del Cliente',
			'apellido_cliente' => 'Apellido del Cliente',
			'tel_cliente' => 'Tel Cliente',
			'email' => 'Email',
			'id_estado' => 'Id Estado',
			'ciudad' => 'Ciudad',
			'code' => 'Code',
			'motivo' => 'Motivo',
			'politicas_cancelacion' => 'Politicas Cancelacion',
			'desglose_rate' => 'Desglose Rate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agente',$this->id_agente);
		$criteria->compare('fecha_llegada',$this->fecha_llegada,true);
		$criteria->compare('hora_vuelo_llegada',$this->hora_vuelo_llegada,true);
		$criteria->compare('aerolinea_llegada',$this->aerolinea_llegada,true);
		$criteria->compare('num_vuelo_llegada',$this->num_vuelo_llegada,true);
		$criteria->compare('fecha_salida',$this->fecha_salida,true);
		$criteria->compare('hora_pick_up',$this->hora_pick_up,true);
		$criteria->compare('hora_vuelo_salida',$this->hora_vuelo_salida,true);
		$criteria->compare('aerolinea_salida',$this->aerolinea_salida,true);
		$criteria->compare('num_vuelo_salida',$this->num_vuelo_salida,true);
		$criteria->compare('servicio',$this->servicio);
		$criteria->compare('deluxe',$this->deluxe);
		$criteria->compare('direccion',$this->direccion);
		$criteria->compare('pasajeros',$this->pasajeros);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('fecha_limite_api',$this->fecha_limite_api,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('tipo_cambio',$this->tipo_cambio);
		$criteria->compare('total',$this->total);
		$criteria->compare('total_tc',$this->total_tc);
		$criteria->compare('saldo',$this->saldo);
		$criteria->compare('saldo_api',$this->saldo_api);
		$criteria->compare('tarifa_agencia',$this->tarifa_agencia);
		$criteria->compare('tarifa_neta',$this->tarifa_neta);
		$criteria->compare('moneda',$this->moneda,true);
		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);
		$criteria->compare('apellido_cliente',$this->apellido_cliente,true);
		$criteria->compare('tel_cliente',$this->tel_cliente,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('id_estado',$this->id_estado);
		$criteria->compare('ciudad',$this->ciudad,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('politicas_cancelacion',$this->politicas_cancelacion,true);
		$criteria->compare('desglose_rate',$this->desglose_rate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TransportacionReservacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
