<?php

/**
 * This is the model class for table "{{venta}}".
 *
 * The followings are the available columns in table '{{venta}}':
 * @property integer $id_venta
 * @property double $total
 * @property double $saldo
 * @property string $fecha
 * @property string $cliente
 * @property string $id_user
 * @property integer $id_agencia
 * @property string $id_hotel
 * @property string $observacion
 * @property string $estatus
 *
 * The followings are the available model relations:
 * @property Usuarios $idUser
 * @property Agencias $idAgencia
 * @property Hoteles $idHotel
 * @property VentaDesglose[] $ventaDesgloses
 */
class Venta extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Venta the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{venta}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('total, cliente, id_agencia, fecha_inicio, fecha_final', 'required'),
			array('id_agencia, liberado, revisado', 'numerical', 'integerOnly'=>true),
			array('total, saldo, comision', 'numerical'),
			array('cliente', 'length', 'max'=>100),
			array('id_user, id_hotel', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>1),
			array('observacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_venta, total, saldo, fecha, cliente, id_user, id_agencia, id_hotel, fecha_inicio, fecha_final, observacion, estatus, liberado, revisado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_user'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'ventaDesgloses' => array(self::HAS_MANY, 'VentaDesglose', 'id_venta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_venta' => 'Id Venta',
			'total' => 'Total',
			'saldo' => 'Saldo',
			'comision' => 'Comisión',
			'fecha' => 'Fecha',
			'cliente' => 'Cliente',
			'id_user' => 'Elaboro',
			'id_agencia' => 'Agencia',
			'id_hotel' => 'Hotel',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'observacion' => 'Observaciones',
			'estatus' => 'Estatus',
			'liberado' => 'Liberado',
			'revisado' => 'Realizado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_venta',$this->id_venta);
		$criteria->compare('total',$this->total);
		$criteria->compare('saldo',$this->saldo);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('cliente',$this->cliente,true);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('observacion',$this->observacion,true);
		$criteria->compare('estatus',$this->estatus,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}