<?php

/**
 * This is the model class for table "{{venta_desglose}}".
 *
 * The followings are the available columns in table '{{venta_desglose}}':
 * @property integer $id_desglose
 * @property integer $id_producto
 * @property string $descripcion
 * @property integer $cantidad
 * @property double $precio
 * @property integer $id_venta
 *
 * The followings are the available model relations:
 * @property Venta $idVenta
 * @property CatServicios $idProducto
 */
class VentaDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VentaDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{venta_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_producto, descripcion, cantidad, precio, id_venta', 'required'),
			array('id_producto, cantidad, id_venta', 'numerical', 'integerOnly'=>true),
			array('precio', 'numerical'),
			array('descripcion', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_desglose, id_producto, descripcion, cantidad, precio, id_venta', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idVenta' => array(self::BELONGS_TO, 'Venta', 'id_venta'),
			'idProducto' => array(self::BELONGS_TO, 'CatServicios', 'id_producto'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_desglose' => 'Id Desglose',
			'id_producto' => 'Id Producto',
			'descripcion' => 'Descripcion',
			'cantidad' => 'Cantidad',
			'precio' => 'Precio',
			'id_venta' => 'Id Venta',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_desglose',$this->id_desglose);
		$criteria->compare('id_producto',$this->id_producto);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('cantidad',$this->cantidad);
		$criteria->compare('precio',$this->precio);
		$criteria->compare('id_venta',$this->id_venta);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}