<?php

/**
 * This is the model class for table "view_recibos_notascredito".
 *
 * The followings are the available columns in table 'view_recibos_notascredito':
 * @property string $tipo
 * @property integer $id
 * @property integer $id_agencia
 * @property string $nombre_agencia
 * @property string $foto_agencia
 * @property string $tipo_pago
 * @property string $fecha
 * @property double $importe
 */
class ViewRecibosNotascredito extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ViewRecibosNotascredito the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'view_recibos_notascredito';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id, id_agencia', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('tipo', 'length', 'max'=>2),
			array('nombre_agencia, foto_agencia', 'length', 'max'=>255),
			array('tipo_pago', 'length', 'max'=>150),
			array('fecha', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tipo, id, id_sucursal, id_agencia, nombre_agencia, foto_agencia, tipo_pago, fecha, importe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		 
		return array(
			'idSucursal' => array(self::BELONGS_TO, 'Sucursales', 'id_sucursal'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tipo' => 'Tipo',
			'id' => 'ID',
			'id_agencia' => 'Id Agencia',
			'nombre_agencia' => 'Nombre Agencia',
			'foto_agencia' => 'Foto Agencia',
			'tipo_pago' => 'Tipo Pago',
			'fecha' => 'Fecha',
			'id_sucursal' => 'Sucursal',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('id',$this->id);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('nombre_agencia',$this->nombre_agencia,true);
		$criteria->compare('foto_agencia',$this->foto_agencia,true);
		$criteria->compare('tipo_pago',$this->tipo_pago,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('importe',$this->importe);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}