<?php

/**
 * This is the model class for table "vw_reservacion_desglose".
 *
 * The followings are the available columns in table 'vw_reservacion_desglose':
 * @property string $id_reservacion
 * @property string $id_desglose
 * @property string $base_habitacion
 * @property string $tipo_habitacion
 * @property string $num_adultos
 * @property double $num_menores
 * @property string $edades_menores
 */
class VwReservacionDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VwReservacionDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vw_reservacion_desglose';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, base_habitacion, tipo_habitacion, num_adultos, num_menores', 'required'),
			array('num_menores', 'numerical'),
			array('id_reservacion, id_desglose, num_adultos', 'length', 'max'=>10),
			array('base_habitacion', 'length', 'max'=>45),
			array('tipo_habitacion', 'length', 'max'=>255),
			array('edades_menores', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_reservacion, id_desglose, base_habitacion, tipo_habitacion, num_adultos, num_menores, edades_menores', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_reservacion' => 'Id Reservacion',
			'id_desglose' => 'Id Desglose',
			'base_habitacion' => 'Base Habitacion',
			'tipo_habitacion' => 'Tipo Habitacion',
			'num_adultos' => 'Num Adultos',
			'num_menores' => 'Num Menores',
			'edades_menores' => 'Edades Menores',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_desglose',$this->id_desglose,true);
		$criteria->compare('base_habitacion',$this->base_habitacion,true);
		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);
		$criteria->compare('num_adultos',$this->num_adultos,true);
		$criteria->compare('num_menores',$this->num_menores);
		$criteria->compare('edades_menores',$this->edades_menores,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}